/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.manager.internal;

import cz.integsoft.mule.license.api.LicenseManager;
import cz.integsoft.mule.license.api.LicenseReader;
import cz.integsoft.mule.license.api.Pair;
import cz.integsoft.mule.license.api.SecurityService;
import cz.integsoft.mule.license.api.exception.InvalidLicenseException;
import cz.integsoft.mule.license.api.exception.LicenseManagementException;
import cz.integsoft.mule.license.api.exception.MaxCallsReachedException;
import cz.integsoft.mule.license.api.exception.NoLicenseAvailableException;
import cz.integsoft.mule.license.api.license.AbstractLimitedLicense;
import cz.integsoft.mule.license.api.license.DemoLicense;
import cz.integsoft.mule.license.api.license.License;
import cz.integsoft.mule.license.api.license.LicenseType;
import cz.integsoft.mule.license.api.license.LicenseUsage;
import cz.integsoft.mule.license.api.license.StartupLicense;
import cz.integsoft.mule.license.manager.api.LicensePool;
import cz.integsoft.mule.license.manager.internal.BorrowerMetadata;
import cz.integsoft.mule.license.manager.internal.DefaultLicensePool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DefaultLicenseManager
implements LicenseManager {
    private static final Logger a = LoggerFactory.getLogger(DefaultLicenseManager.class);
    private LicenseReader b;
    private DefaultLicensePool c;
    private DefaultLicensePool d;
    private LicensePool e;
    private LicensePool f;
    private boolean g = true;
    private boolean h = true;
    private Map<Pair<License, BorrowerMetadata>, AtomicInteger> i;
    private Map<Pair<License, BorrowerMetadata>, AtomicInteger> j;
    private static final List<License> k = Collections.emptyList();

    public DefaultLicenseManager(String string, String string2, String string3, String string4, String string5, String string6) throws GeneralSecurityException, IOException {
        a.info("Creating a new license manager instance {}", (Object)this);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        this.b = new LicenseReader(SecurityService.loadPublicKey((InputStream)inputStream, (String)"PKCS12", (String)string2, (String)string3, (String)string4), string5, string6);
    }

    public List<License> loadLicenses(Resource resource2) throws LicenseManagementException, IOException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.b(mBeanServer);
        a.info("Loading licenses from {}", (Object)resource2);
        Set set = Collections.synchronizedSet(new HashSet());
        ArrayList<License> arrayList = new ArrayList<License>();
        ArrayList<License> arrayList2 = new ArrayList<License>();
        ArrayList<License> arrayList3 = new ArrayList<License>();
        ArrayList<License> arrayList4 = new ArrayList<License>();
        System.out.println("Integration Eye license manager is loading licenses...");
        ArrayList<Resource> arrayList5 = new ArrayList<Resource>();
        if (resource2.isFile() && resource2.getFile().isDirectory()) {
            ((Stream)Files.list(resource2.getFile().toPath()).parallel()).filter(path -> path.getFileName().toString().matches("integrationeye_.*.lic")).forEach(path -> arrayList5.add((Resource)new FileSystemResource(path)));
        } else {
            arrayList5.add(resource2);
        }
        arrayList5.forEach(resource -> {
            block10: {
                try {
                    License license = this.b.read(resource);
                    ArrayList<Pair> arrayList = new ArrayList<Pair>();
                    arrayList.add(new Pair((Object)"Filename", (Object)resource.getFilename()));
                    arrayList.add(new Pair((Object)"Version", (Object)license.getVersion()));
                    if (!set.contains(license.getId())) {
                        license.printLicense((OutputStream)System.out, arrayList);
                        if (license.isValid()) {
                            set.add(license.getId());
                            switch (license.getType()) {
                                case offline: {
                                    arrayList4.add(license);
                                    this.g = false;
                                    this.h = false;
                                    break block10;
                                }
                                case online: {
                                    arrayList3.add(license);
                                    this.g = false;
                                    this.h = false;
                                    break block10;
                                }
                                case demo: {
                                    arrayList.add(license);
                                    break block10;
                                }
                                case startup: {
                                    arrayList2.add(license);
                                    this.g = false;
                                    break block10;
                                }
                                default: {
                                    throw new IllegalStateException("Unsupported license type " + license.getType());
                                }
                            }
                        }
                        System.out.printf("License %1$s is invalid, so skipping it.\n", license.getId());
                        break block10;
                    }
                    System.out.printf("License %1$s is already in use, so skipping it. Please remove duplicate license %2$s.\n", license.getId(), resource.getFilename());
                }
                catch (InvalidLicenseException | IOException | GeneralSecurityException throwable) {
                    a.warn("Failed load license from {}: {}", resource, (Object)throwable.getMessage());
                }
            }
        });
        if (this.g) {
            this.c = new DefaultLicensePool(arrayList, LicenseType.demo);
        } else {
            this.c = new DefaultLicensePool(k, LicenseType.demo);
            this.c.setEnabled(false);
            System.out.println("Disabling Demo license pool since there are licenses with higher precedence, see https://www.integrationeye.com/faq#license-loading-priorities.");
        }
        if (this.h) {
            this.d = new DefaultLicensePool(arrayList2, LicenseType.startup);
        } else {
            this.d = new DefaultLicensePool(k, LicenseType.startup);
            this.d.setEnabled(false);
            System.out.println("Disabling Start-up license pool since there are licenses with higher precedence, see https://www.integrationeye.com/faq#license-loading-priorities.");
        }
        this.f = new DefaultLicensePool(arrayList3, LicenseType.online);
        this.e = new DefaultLicensePool(arrayList4, LicenseType.offline);
        if (!(this.c.remaining() <= 0 && this.d.remaining() <= 0 || this.f.remaining() <= 0 && this.e.remaining() <= 0)) {
            System.out.printf("Warning: You're mixing different types of licenses together, see https://www.integrationeye.com/faq#mixing-licenses for more information.\n", new Object[0]);
        }
        Map map = this.g ? arrayList.stream().collect(Collectors.groupingBy(License::getLicenseUsage, Collectors.counting())) : Collections.emptyMap();
        Map map2 = this.h ? arrayList2.stream().collect(Collectors.groupingBy(License::getLicenseUsage, Collectors.counting())) : Collections.emptyMap();
        Map<LicenseUsage, Long> map3 = arrayList3.stream().collect(Collectors.groupingBy(License::getLicenseUsage, Collectors.counting()));
        Map<LicenseUsage, Long> map4 = arrayList4.stream().collect(Collectors.groupingBy(License::getLicenseUsage, Collectors.counting()));
        if (map.getOrDefault(LicenseUsage.non_production, 0L) > 0L && map.getOrDefault(LicenseUsage.production, 0L) > 0L) {
            System.out.printf("Warning: You're mixing different license usages together in demo pool. Production #%1$s Non-production #%2$s\n", map.getOrDefault(LicenseUsage.production, 0L), map.getOrDefault(LicenseUsage.non_production, 0L));
        }
        if (map2.getOrDefault(LicenseUsage.non_production, 0L) > 0L && map2.getOrDefault(LicenseUsage.production, 0L) > 0L) {
            System.out.printf("Warning: You're mixing different license usages together in start-up pool. Production #%1$s Non-production #%2$s\n", map2.getOrDefault(LicenseUsage.production, 0L), map2.getOrDefault(LicenseUsage.non_production, 0L));
        }
        if (map3.getOrDefault(LicenseUsage.non_production, 0L) > 0L && map3.getOrDefault(LicenseUsage.production, 0L) > 0L) {
            System.out.printf("Warning: You're mixing different license usages together in online pool. Production #%1$s Non-production #%2$s\n", map3.getOrDefault(LicenseUsage.production, 0L), map3.getOrDefault(LicenseUsage.non_production, 0L));
        }
        if (map4.getOrDefault(LicenseUsage.non_production, 0L) > 0L && map4.getOrDefault(LicenseUsage.production, 0L) > 0L) {
            System.out.printf("Warning: You're mixing different license usages together in offline pool. Production #%1$s Non-production #%2$s\n", map4.getOrDefault(LicenseUsage.production, 0L), map4.getOrDefault(LicenseUsage.non_production, 0L));
        }
        this.a(this.c, "cz.integsoft.integrationeye.license.pool:type=DemoLicensePool", mBeanServer);
        this.a(this.d, "cz.integsoft.integrationeye.license.pool:type=StartupLicensePool", mBeanServer);
        this.a(this.e, "cz.integsoft.integrationeye.license.pool:type=OfflineLicensePool", mBeanServer);
        this.a(this.f, "cz.integsoft.integrationeye.license.pool:type=OnlineLicensePool", mBeanServer);
        this.a(mBeanServer);
        List<License> list = Stream.of(this.g ? arrayList : k, this.h ? arrayList2 : k, arrayList4, arrayList3).flatMap(Collection::stream).collect(Collectors.toList());
        System.out.printf("License pool is ready, #%1s Integration Eye license(s) loaded successfully and ready for use.\n", list.size());
        System.out.printf("You can watch license pool state using MBean, see https://www.integrationeye.com/faq#watch-license-pool for more information.\n", new Object[0]);
        return list;
    }

    public License borrow(String string, String string2, String string3) throws NoLicenseAvailableException, LicenseManagementException {
        BorrowerMetadata borrowerMetadata = new BorrowerMetadata(string, string2, string3);
        if (this.g) {
            if (this.c == null) {
                throw new NoLicenseAvailableException();
            }
            if (this.i == null) {
                this.i = new ConcurrentHashMap<Pair<License, BorrowerMetadata>, AtomicInteger>();
            }
            DemoLicense demoLicense = (DemoLicense)this.c.activateLicense(borrowerMetadata);
            this.i.put((Pair<License, BorrowerMetadata>)new Pair((Object)demoLicense, (Object)new BorrowerMetadata(string, string2, string3)), new AtomicInteger(demoLicense.getMaxCalls()));
            return demoLicense;
        }
        if (this.h) {
            if (this.d == null) {
                throw new NoLicenseAvailableException();
            }
            if (this.j == null) {
                this.j = new ConcurrentHashMap<Pair<License, BorrowerMetadata>, AtomicInteger>();
            }
            StartupLicense startupLicense = (StartupLicense)this.d.activateLicense(borrowerMetadata);
            this.j.put((Pair<License, BorrowerMetadata>)new Pair((Object)startupLicense, (Object)new BorrowerMetadata(string, string2, string3)), new AtomicInteger(startupLicense.getMaxCalls()));
            return startupLicense;
        }
        try {
            if (this.e == null) {
                throw new NoLicenseAvailableException();
            }
            return this.e.activateLicense(borrowerMetadata);
        }
        catch (NoLicenseAvailableException noLicenseAvailableException) {
            if (this.f == null) {
                throw new NoLicenseAvailableException();
            }
            return this.f.activateLicense(borrowerMetadata);
        }
    }

    public boolean release(License license, String string, String string2, String string3) throws LicenseManagementException {
        BorrowerMetadata borrowerMetadata = new BorrowerMetadata(string, string2, string3);
        switch (license.getType()) {
            case offline: {
                return this.e.passivateLicense(license, borrowerMetadata);
            }
            case online: {
                return this.f.passivateLicense(license, borrowerMetadata);
            }
            case demo: {
                if (this.i != null) {
                    this.i.remove(new Pair((Object)license, (Object)borrowerMetadata));
                }
                return this.c.passivateLicense(license, borrowerMetadata);
            }
            case startup: {
                if (this.j != null) {
                    this.j.remove(new Pair((Object)license, (Object)borrowerMetadata));
                }
                return this.d.passivateLicense(license, borrowerMetadata);
            }
        }
        throw new IllegalStateException("Unsupported license type " + license.getType());
    }

    public void incCall(License license, String string, String string2, String string3) throws MaxCallsReachedException, LicenseManagementException {
        Map<Pair<License, BorrowerMetadata>, AtomicInteger> map;
        if (!this.a(license)) {
            return;
        }
        BorrowerMetadata borrowerMetadata = new BorrowerMetadata(string, string2, string3);
        Pair pair = new Pair((Object)license, (Object)borrowerMetadata);
        Map<Pair<License, BorrowerMetadata>, AtomicInteger> map2 = map = LicenseType.demo.equals((Object)license.getType()) ? this.i : this.j;
        if (!map.containsKey(pair)) {
            throw new LicenseManagementException(MessageFormat.format("Could not find demo license and borrower pair: {0}", pair));
        }
        int n = map.get(pair).decrementAndGet();
        if (n + 1 <= 0) {
            map.put((Pair<License, BorrowerMetadata>)pair, new AtomicInteger(0));
            throw new MaxCallsReachedException(MessageFormat.format("Maximum number of calls {0} have been reached by license id {1} and borrower {2}", ((AbstractLimitedLicense)license).getMaxCalls(), license.getId(), borrowerMetadata));
        }
        if (n == 0) {
            a.warn("License {} borrowed by {} has no more calls left! You have to restart Mule runtime to continue or buy a normal license.", (Object)license, (Object)borrowerMetadata);
        } else {
            a.debug("License {} has still {} remaining calls.", (Object)license, (Object)n);
        }
    }

    public String getLicenseManagerId() {
        return this.toString();
    }

    private void a(LicensePool licensePool, String string, MBeanServer mBeanServer) {
        try {
            ObjectName objectName = new ObjectName(string);
            mBeanServer.registerMBean(licensePool, objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
            a.warn("Failed to register JMX pool beans", (Throwable)jMException);
        }
    }

    private void a(MBeanServer mBeanServer) {
        try {
            ObjectName objectName = new ObjectName("cz.integsoft.integrationeye.license.manager:type=LicenseManager");
            mBeanServer.registerMBean(this, objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
            a.warn("Failed to register JMX license manager", (Throwable)jMException);
        }
    }

    private void b(MBeanServer mBeanServer) throws LicenseManagementException {
        try {
            if (mBeanServer.isRegistered(new ObjectName("cz.integsoft.integrationeye.license.manager:type=LicenseManager"))) {
                throw new LicenseManagementException("The license manager is already registered. This means that you try to use more than one license manager in the JVM. This is not allowed!");
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new LicenseManagementException("Failed to check status! " + malformedObjectNameException.getLocalizedMessage(), (Throwable)malformedObjectNameException);
        }
    }

    private boolean a(License license) {
        return LicenseType.demo.equals((Object)license.getType()) || LicenseType.startup.equals((Object)license.getType());
    }
}

