/*
 * Decompiled with CFR 0.152.
 */
package cz.integsoft.mule.license.manager.internal;

import cz.integsoft.mule.license.api.Pair;
import cz.integsoft.mule.license.api.exception.LicenseManagementException;
import cz.integsoft.mule.license.api.exception.NoLicenseAvailableException;
import cz.integsoft.mule.license.api.license.License;
import cz.integsoft.mule.license.api.license.LicenseType;
import cz.integsoft.mule.license.manager.api.ArrayListQueue;
import cz.integsoft.mule.license.manager.api.LicensePool;
import cz.integsoft.mule.license.manager.api.LicensePoolMBean;
import cz.integsoft.mule.license.manager.internal.BorrowerMetadata;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultLicensePool
implements LicensePool {
    private static final Logger a = LoggerFactory.getLogger(DefaultLicensePool.class);
    private final ReentrantLock b = new ReentrantLock(true);
    private ArrayListQueue<License> c = new ArrayListQueue();
    private ArrayListQueue<Pair<License, BorrowerMetadata>> d = new ArrayListQueue();
    private LicenseType e;
    private boolean f = true;

    DefaultLicensePool(List<License> list, LicenseType licenseType) {
        if (licenseType == null) {
            throw new IllegalArgumentException("Cannot instantiate license pool with empty license type!");
        }
        if (list == null) {
            throw new IllegalArgumentException("Cannot instantiate license pool with empty licenses!");
        }
        this.e = licenseType;
        list.forEach(license -> IntStream.rangeClosed(1, license.getCount()).forEach(n -> this.c.add((License)license)));
        a.debug("License pool loaded with #{} licenses for license type {}", (Object)this.c.size(), (Object)licenseType.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public License activateLicense(BorrowerMetadata borrowerMetadata) throws NoLicenseAvailableException, LicenseManagementException {
        if (borrowerMetadata == null) {
            throw new LicenseManagementException("To activate license the caller must send not null borrower metadata");
        }
        this.a();
        this.b.lock();
        try {
            boolean bl = this.d.stream().anyMatch(pair -> ((BorrowerMetadata)pair.getSecond()).equals(borrowerMetadata));
            if (bl) {
                throw new LicenseManagementException(MessageFormat.format("The borrower {0} has already one license borrowed.", borrowerMetadata));
            }
            if (this.c.isEmpty()) {
                throw new NoLicenseAvailableException();
            }
            License license = this.a(borrowerMetadata);
            a.debug("Activating license {} for borrower {}", (Object)license, (Object)borrowerMetadata);
            this.d.add((Pair<License, BorrowerMetadata>)new Pair((Object)license, (Object)borrowerMetadata));
            License license2 = license;
            return license2;
        }
        finally {
            this.b.unlock();
        }
    }

    @Override
    public boolean passivateLicense(License license, BorrowerMetadata borrowerMetadata) throws LicenseManagementException {
        if (license == null || borrowerMetadata == null) {
            throw new LicenseManagementException("To passivate license the caller must send not null license and borrower metadata");
        }
        this.a();
        Pair pair = new Pair((Object)license, (Object)borrowerMetadata);
        a.debug("Passivating license {} for borrower {}", (Object)license, (Object)borrowerMetadata);
        this.b.lock();
        try {
            Optional<Pair> optional = this.d.stream().filter(pair2 -> pair2.equals((Object)pair)).findFirst();
            if (optional.isPresent()) {
                boolean bl = this.d.remove(optional.get());
                boolean bl2 = false;
                if (bl) {
                    bl2 = this.c.offer(license);
                }
                if (!bl2) {
                    this.d.offer((Pair<License, BorrowerMetadata>)pair);
                }
                boolean bl3 = bl && bl2;
                return bl3;
            }
            throw new LicenseManagementException(MessageFormat.format("Could not find requested pair {0} in used licenses!", pair));
        }
        finally {
            this.b.unlock();
        }
    }

    @Override
    public boolean validateLicense(License license) {
        try {
            this.a();
        }
        catch (LicenseManagementException licenseManagementException) {
            a.warn("Error validationg license: " + licenseManagementException.getLocalizedMessage(), (Throwable)licenseManagementException);
            return false;
        }
        return this.c.stream().anyMatch(license2 -> license2.equals(license));
    }

    @Override
    public void destroyLicense(License license) {
        if (license == null) {
            return;
        }
        try {
            this.a();
        }
        catch (LicenseManagementException licenseManagementException) {
            a.warn("Error destroying license: " + licenseManagementException.getLocalizedMessage(), (Throwable)licenseManagementException);
            return;
        }
        this.b.lock();
        try {
            this.c.removeIf(license2 -> license2.equals(license));
            this.d.removeIf(pair -> ((License)pair.getFirst()).equals(license));
        }
        finally {
            this.b.unlock();
        }
    }

    @Override
    public int used() {
        if (this.f) {
            return this.d.size();
        }
        return 0;
    }

    @Override
    public int remaining() {
        if (this.f) {
            return this.c.size();
        }
        return 0;
    }

    @Override
    public LicenseType getServedLicenseType() {
        return this.e;
    }

    @Override
    public List<LicensePoolMBean.UsedLicenseContainer> usedLicenses() {
        if (this.f) {
            return this.d.stream().map(pair -> new LicensePoolMBean.UsedLicenseContainer(((License)pair.getFirst()).getId(), (BorrowerMetadata)pair.getSecond())).collect(Collectors.toList());
        }
        return new ArrayListQueue<LicensePoolMBean.UsedLicenseContainer>();
    }

    @Override
    public String printUsedLicenses() {
        List<LicensePoolMBean.UsedLicenseContainer> list = this.usedLicenses();
        if (list.isEmpty()) {
            return "No licenses are in use.";
        }
        StringBuilder stringBuilder = new StringBuilder();
        list.stream().forEach(usedLicenseContainer -> stringBuilder.append(usedLicenseContainer).append('\n'));
        return stringBuilder.toString();
    }

    void setEnabled(boolean bl) {
        this.f = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.f;
    }

    private License a(BorrowerMetadata borrowerMetadata) throws NoLicenseAvailableException {
        License license = this.c.poll();
        if (license == null) {
            throw new NoLicenseAvailableException();
        }
        if (license.isValid()) {
            return license;
        }
        return this.a(borrowerMetadata);
    }

    private void a() throws LicenseManagementException {
        if (!this.f) {
            throw new LicenseManagementException(MessageFormat.format("This pool for license type {0} is disabled! Please check why the pool is in use.", this.e.name()));
        }
    }
}

